﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework;

namespace CashierCrisis.Entities
{
    public class StatusBarComponent : Component
    {
        public Texture2D Sprite { get; set; }
        public Vector2 Position { get; set; }
        public Color FillColor { get; set; }
        public Color LowColor { get; set; }
        public int Low { get; set; }
        public int Current { get; set; }
        public int BarHeight { get; set; }

        public StatusBarComponent(string name)
            : base(name)
        {
            BarHeight = 24;
        }

        public override void Draw(Microsoft.Xna.Framework.Graphics.SpriteBatch spriteBatch)
        {
            spriteBatch.Draw(Sprite, Position, new Rectangle(0, 0, Sprite.Width, BarHeight), Color.White);
            Color currentColor = (Current > Low) ? FillColor : LowColor;
            spriteBatch.Draw(Sprite, Position, new Rectangle(0, BarHeight, (int)(Sprite.Width * ((double)Current / 100)), 24), currentColor);
        }
    }
}
